/*
 * Copyright (c) 2008-2018, RF-Embedded GmbH
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 *  1. Redistributions of source code must retain the above copyright notice,
 *     this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright notice,
 *     this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
 * SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "QrfeTraceInterface.h"

#include <QDateTime>

using namespace QrfeReaderInterface;

/**
 * @brief QrfeTraceInterface::QrfeTraceInterface is the constructor
 */
QrfeTraceInterface::QrfeTraceInterface()
    : m_traceLevel(0)
{
}

/**
 * @brief QrfeTraceInterface::setTraceLevel sets the trace level of the trace functions
 * @param traceLevel    The desired tracelevel
 */
void QrfeTraceInterface::setTraceLevel(int traceLevel)
{
    m_traceLevel = traceLevel;
}

/**
 * @brief QrfeTraceInterface::getTraceLevel returns the tracelevel
 * @return The set tracelevel
 */
int  QrfeTraceInterface::getTraceLevel()
{
    return m_traceLevel;
}

/**
 * @brief QrfeTraceInterface::trc traces the message to the configured interface, if the tracelevel is desired
 * @param level     Level of the message
 * @param text      Message
 */
void QrfeTraceInterface::trc(int level, QString text)
{
    if (level > m_traceLevel)
        return;

    QString msg = "[" + QDateTime::currentDateTime().toString("HH:mm:ss.zzz") + "] - " + text;
    write(msg);
}
